/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.item;

import java.util.UUID;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.impl.AzItemAnimator;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.model.AzBoneSnapshot;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.item.AzItemArmRenderUtil;
import mod.azure.azurelib.common.render.item.AzItemRendererConfig;
import mod.azure.azurelib.common.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.common.render.item.AzItemRendererPipelineContext;
import mod.azure.azurelib.common.util.client.RenderUtils;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzItemModelRenderer
extends AzModelRenderer<UUID, class_1799> {
    protected final AzItemRendererPipeline itemRendererPipeline;

    public AzItemModelRenderer(AzItemRendererPipeline itemRendererPipeline, AzLayerRenderer<UUID, class_1799> layerRenderer) {
        super(itemRendererPipeline, layerRenderer);
        this.itemRendererPipeline = itemRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<UUID, class_1799> context, boolean isReRender) {
        if (!isReRender) {
            class_1799 animatable = context.animatable();
            AzItemAnimator animator = this.itemRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, animatable, context.partialTick());
            }
        }
        class_4587 poseStack = context.poseStack();
        this.itemRendererPipeline.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<UUID, class_1799> context, AzBone bone, boolean isReRender) {
        boolean isArmBone;
        AzItemRendererPipelineContext itemContext;
        class_4587 poseStack = context.poseStack();
        AzItemRendererConfig itemRendererConfig = (AzItemRendererConfig)this.itemRendererPipeline.config();
        boolean shouldFreezeTransforms = !itemRendererConfig.shouldAnimateInContext((itemContext = (AzItemRendererPipelineContext)this.itemRendererPipeline.context()).getTransformType());
        float origPosX = 0.0f;
        float origPosY = 0.0f;
        float origPosZ = 0.0f;
        float origRotX = 0.0f;
        float origRotY = 0.0f;
        float origRotZ = 0.0f;
        float origScaleX = 0.0f;
        float origScaleY = 0.0f;
        float origScaleZ = 0.0f;
        if (shouldFreezeTransforms) {
            origPosX = bone.getPosX();
            origPosY = bone.getPosY();
            origPosZ = bone.getPosZ();
            origRotX = bone.getRotX();
            origRotY = bone.getRotY();
            origRotZ = bone.getRotZ();
            origScaleX = bone.getScaleX();
            origScaleY = bone.getScaleY();
            origScaleZ = bone.getScaleZ();
            AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
            bone.setPosX(initialSnapshot.getOffsetX());
            bone.setPosY(initialSnapshot.getOffsetY());
            bone.setPosZ(initialSnapshot.getOffsetZ());
            bone.setRotX(initialSnapshot.getRotX());
            bone.setRotY(initialSnapshot.getRotY());
            bone.setRotZ(initialSnapshot.getRotZ());
            bone.setScaleX(initialSnapshot.getScaleX());
            bone.setScaleY(initialSnapshot.getScaleY());
            bone.setScaleZ(initialSnapshot.getScaleZ());
        }
        poseStack.method_22903();
        AzItemAnimator animator = this.itemRendererPipeline.getRenderer().getAnimator();
        boolean isAnimationPlaying = false;
        boolean firstPerson = Services.PLATFORM.isModLoaded("firstperson");
        boolean bl = isArmBone = AzItemArmRenderUtil.isArmBone(bone) && !firstPerson;
        if (animator != null) {
            for (AzAnimationController controller : animator.getAnimationControllerContainer().getAll()) {
                AzAnimationController azController;
                if (!(controller instanceof AzAnimationController) || !(azController = controller).stateMachine().isPlaying()) continue;
                isAnimationPlaying = true;
                break;
            }
        }
        if (isArmBone && isAnimationPlaying) {
            AzItemArmRenderUtil.renderArmForBone(context, bone, this);
        }
        if (bone.isTrackingMatrices()) {
            class_1799 animatable = context.animatable();
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.itemRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(animatable, 1.0f).method_46409()));
        }
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        super.renderRecursively(context, bone, isReRender);
        if (shouldFreezeTransforms) {
            bone.setPosX(origPosX);
            bone.setPosY(origPosY);
            bone.setPosZ(origPosZ);
            bone.setRotX(origRotX);
            bone.setRotY(origRotY);
            bone.setRotZ(origRotZ);
            bone.setScaleX(origScaleX);
            bone.setScaleY(origScaleY);
            bone.setScaleZ(origScaleZ);
        }
        poseStack.method_22909();
    }

    public class_243 getRenderOffset(class_1799 itemStack, float f) {
        return class_243.field_1353;
    }
}

